/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.forge.duckling;

import java.util.HashMap;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import tech.thatgravyboat.duckling.Duckling;
import tech.thatgravyboat.duckling.common.registry.ModSpawns;
import tech.thatgravyboat.duckling.platform.SpawnData;
import tech.thatgravyboat.forge.duckling.DucklingForgeClient;
import tech.thatgravyboat.forge.duckling.services.ForgeRegistryService;

@Mod(value="duckling")
public class DucklingForge {
    private static boolean registeredSpawns = false;

    public DucklingForge() {
        Duckling.init();
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(DucklingForge::addEntityAttributes);
        bus.addListener(this::onComplete);
        ForgeRegistryService.ITEMS.register(bus);
        ForgeRegistryService.ENTITIES.register(bus);
        ForgeRegistryService.SOUNDS.register(bus);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> DucklingForgeClient::init);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void onComplete(FMLLoadCompleteEvent event) {
        ModSpawns.addSpawnRules();
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void addSpawns(BiomeLoadingEvent event) {
        if (!registeredSpawns) {
            ModSpawns.addSpawns();
            registeredSpawns = true;
        }
        for (SpawnData spawnData : ForgeRegistryService.ENTITY_SPAWNS.get((Object)event.getCategory())) {
            if (!spawnData.shouldSpawn().test(event.getClimate().f_47680_)) continue;
            event.getSpawns().m_48376_(spawnData.group(), new MobSpawnSettings.SpawnerData(spawnData.entityType(), spawnData.weight(), spawnData.min(), spawnData.max()));
        }
    }

    public static void addEntityAttributes(EntityAttributeCreationEvent event) {
        HashMap<EntityType<? extends LivingEntity>, AttributeSupplier.Builder> attributes = new HashMap<EntityType<? extends LivingEntity>, AttributeSupplier.Builder>();
        Duckling.addEntityAttributes(attributes);
        attributes.forEach((entity, builder) -> event.put(entity, builder.m_22265_()));
    }
}

